import sqlite3

def lies_anwesenheit_db(db_pfad):
    try:
        # Verbindung zur Datenbank herstellen
        connection = sqlite3.connect(db_pfad)
        cursor = connection.cursor()

        # SQL-Abfrage ausführen, um alle Daten aus der Tabelle 'scans' zu holen
        query = "SELECT * FROM scans"
        cursor.execute(query)

        # Spaltennamen extrahieren
        spalten = [beschreibung[0] for beschreibung in cursor.description]
        print(f"{' | '.join(spalten)}")
        print("-" * 100)

        # Datensätze zeilenweise auslesen
        rows = cursor.fetchall()
        for row in rows:
            print(f"{row[0]} | {row[1]} | {row[2]} | {row[3]} | {row[4]} | {row[5]} | {row[6]}")

    except sqlite3.Error as e:
        print(f"Fehler beim Lesen der Datenbank: {e}")
    
    finally:
        if connection:
            connection.close()

# Start des Scripts
if __name__ == "__main__":
    lies_anwesenheit_db('anwesenheit.db')
