import sqlite3
import os

# Pfad zur Datenbank
DB_FILE = "/home/pi/mitglieder.db"

def read_database_readonly():
    # Prüfen, ob die Datei existiert
    if not os.path.exists(DB_FILE):
        print(f"Fehler: Die Datei {DB_FILE} wurde nicht gefunden.")
        return

    try:
        # Verbindung im Read-Only Modus (mode=ro) öffnen
        conn = sqlite3.connect(f"file:{DB_FILE}?mode=ro", uri=True)
        c = conn.cursor()

        print("\n" + "═"*75)
        print(f"║ {'GARTEN-DATENBANK: MITGLIEDERLISTE':^71} ║")
        print("═"*75)
        
        # Spaltenüberschriften basierend auf deiner DB-Struktur
        print(f"{'Card-ID':<15} | {'Vorname':<15} | {'Nachname':<15} | {'Garten-Nr.'}")
        print("─"*75)

        # Abfrage der vorhandenen Spalten 
        c.execute("SELECT card_id, vorname, name, gartennummer FROM users")
        members = c.fetchall()

        if not members:
            print(" (Die Datenbank enthält momentan keine Einträge)")
        else:
            for m in members:
                # Formatierung der Zeilen
                print(f"{str(m[0]):<15} | {str(m[1]):<15} | {str(m[2]):<15} | {str(m[3])}")

        conn.close()
        print("═"*75 + "\n")

    except sqlite3.OperationalError as e:
        print(f"Fehler beim Zugriff auf die Datenbank: {e}")
    except sqlite3.Error as e:
        print(f"Ein SQLite-Fehler ist aufgetreten: {e}")

if __name__ == "__main__":
    read_database_readonly()
