# -*- coding: utf-8 -*-
import os

# --- SYSTEM INFO ---
VERSION = "V 1.3 @ 2026"
PROJEKT_NAME = "Heckenheld-Pi"

# --- ADMIN EINSTELLUNGEN ---
ADMIN_CHIPS = ["0004645972", "1234567890"] # Hier deine Chipnummer(n) eintragen

# --- PFADE ---
BASE_DIR = "/home/pi"
DB_MITGLIEDER = os.path.join(BASE_DIR, "mitglieder.db")
DB_ANWESENHEIT = os.path.join(BASE_DIR, "anwesenheit.db")
LOGO_PATH = os.path.join(BASE_DIR, "logo.jpg")
LOG_FILE = os.path.join(BASE_DIR, "garten.log")

# --- HARDWARE ---
PRINTER_MAC = "DC:0D:51:AF:BB:36" 
PRINTER_PORT = "/dev/rfcomm0"
RFID_PATH = '/dev/input/by-id/usb-16c0_27db-event-kbd'
LCD_ADDRESS = 0x27
PIN_BUTTON_JA = 25
PIN_BUTTON_NEIN = 27

# --- DRUCKER & ANZEIGE ---
CHARS_PER_LINE = 32
ENABLE_PRINTING = True

# --- WERTUNGSEINSTELLUNGEN ---
ENABLE_WERTUNG = True      
MINUTEN_STUFE_1 = 180      
WERTUNG_STUFE_1 = 3        
MINUTEN_STUFE_2 = 360      
WERTUNG_STUFE_2 = 6        

# --- FTP KONFIGURATION ---
FTP_HOST = ""
FTP_USER = ""
FTP_PASS = ""
FTP_PORT = 21