# -*- coding: utf-8 -*-
import ftplib
import ssl
import os
import logging
import config

# Logging einrichten
logging.basicConfig(level=logging.INFO, format='%(asctime)s - %(levelname)s - %(message)s')

def download_mitglieder():
    try:
        logging.info("Verbindung zum FTP-Server wird aufgebaut (FTPS)...")
        
        # Verbindung über explizites FTPS
        ftps = ftplib.FTP_TLS()
        ftps.connect(config.FTP_HOST, config.FTP_PORT, timeout=30)
        ftps.login(config.FTP_USER, config.FTP_PASS)
        
        # Verschlüsselung für Datentransfer aktivieren
        ftps.prot_p()
        
        # Liste der Dateien im FTP-Verzeichnis zur Prüfung
        files = ftps.nlst()
        if 'mitglieder.db' not in files:
            logging.error("Datei 'mitglieder.db' wurde auf dem Server nicht gefunden!")
            ftps.quit()
            return

        # Datei herunterladen
        logging.info("Lade mitglieder.db herunter...")
        with open(config.DB_MITGLIEDER, 'wb') as f:
            ftps.retrbinary('RETR mitglieder.db', f.write)
        
        ftps.quit()
        logging.info(f"Erfolgreich heruntergeladen und gespeichert unter: {config.DB_MITGLIEDER}")

    except Exception as e:
        logging.error(f"FTP-Fehler beim Download: {e}")

if __name__ == "__main__":
    download_mitglieder()