# -*- coding: utf-8 -*-
import ftplib
import ssl
import os
import logging
from datetime import datetime
import config

# Logging einrichten
logging.basicConfig(level=logging.INFO, format='%(asctime)s - %(levelname)s - %(message)s')

def upload_backup():
    if not os.path.exists(config.DB_ANWESENHEIT):
        logging.error(f"Datei {config.DB_ANWESENHEIT} wurde nicht gefunden!")
        return False

    try:
        # Zeitstempel für den Dateinamen auf dem Server
        timestamp = datetime.now().strftime("%d-%m-%Y-%H-%M")
        remote_filename = f"anwesenheit-{timestamp}.db"

        logging.info("Verbindung zum FTP-Server wird aufgebaut (FTPS)...")
        
        ftps = ftplib.FTP_TLS()
        ftps.connect(config.FTP_HOST, config.FTP_PORT, timeout=30)
        ftps.login(config.FTP_USER, config.FTP_PASS)
        ftps.prot_p()
        
        with open(config.DB_ANWESENHEIT, 'rb') as f:
            logging.info(f"Lade Backup als {remote_filename} hoch...")
            # Nutzt jetzt den Namen mit Zeitstempel
            ftps.storbinary(f'STOR {remote_filename}', f)
        
        ftps.quit()
        logging.info(f"Backup erfolgreich als {remote_filename} hochgeladen.")
        return True

    except Exception as e:
        logging.error(f"FTP-Fehler beim Upload: {e}")
        return False

if __name__ == "__main__":
    upload_backup()