# -*- coding: utf-8 -*-
import time, os, sys, subprocess
from RPLCD.i2c import CharLCD
from gpiozero import Button
import config

PROGRAMME = [
    ("Arbeitseinsatz", "arbeitseinsatz.py"),
    ("System-Info",    "info.py"),
    ("Neustart",       "REBOOT"),
    ("Ausschalten",    "SHUTDOWN")
]

def get_lcd():
    try:
        lcd = CharLCD('PCF8574', config.LCD_ADDRESS)
        lcd.create_char(0, (0x0A, 0x00, 0x0E, 0x01, 0x0F, 0x11, 0x0F, 0x00)) # ä
        lcd.create_char(1, (0x0A, 0x00, 0x0E, 11, 11, 11, 0x0E, 0x00)) # ö
        lcd.create_char(2, (0x0A, 0x00, 0x11, 11, 11, 0x13, 0x0D, 0x00)) # ü
        lcd.create_char(3, (0x00, 0x1E, 0x11, 0x1E, 0x11, 0x11, 0x1E, 0x10)) # ß
        return lcd
    except: return None

def fix_umlaute(text):
    return text.replace('ä', '\x00').replace('ö', '\x01').replace('ü', '\x02').replace('ß', '\x03')

def main():
    lcd = get_lcd()
    if lcd:
        lcd.clear()
        lcd.write_string(config.PROJEKT_NAME.center(16))
        lcd.cursor_pos = (1, 0)
        lcd.write_string(config.VERSION.center(16))
        time.sleep(3.0)

    btn_ja = Button(config.PIN_BUTTON_JA, pull_up=True, bounce_time=0.1)
    btn_nein = Button(config.PIN_BUTTON_NEIN, pull_up=True, bounce_time=0.1)
    idx = 0
    
    while True:
        if lcd:
            lcd.clear()
            name, action = PROGRAMME[idx]
            lcd.write_string(fix_umlaute("Wählen:"))
            lcd.cursor_pos = (1, 0)
            lcd.write_string(fix_umlaute(name))
        
        while True:
            if btn_nein.is_pressed:
                idx = (idx + 1) % len(PROGRAMME)
                time.sleep(0.3); break 
                
            if btn_ja.is_pressed:
                name, action = PROGRAMME[idx]
                if action in ["REBOOT", "SHUTDOWN"]:
                    if lcd:
                        lcd.clear()
                        lcd.write_string(fix_umlaute(name) + "?")
                        lcd.cursor_pos = (1, 0)
                        lcd.write_string(fix_umlaute("Grün bestätigen"))
                    time.sleep(0.5)
                    confirm_start = time.time()
                    confirmed = False
                    while time.time() - confirm_start < 3.0:
                        if btn_ja.is_pressed: confirmed = True; break
                        time.sleep(0.1)
                    if confirmed:
                        if lcd:
                            lcd.clear()
                            lcd.write_string("System " + ("Reboot" if action=="REBOOT" else "Ausschalten"))
                            time.sleep(2.0)
                            # Display ausschalten nur bei Shutdown
                            if action == "SHUTDOWN":
                                lcd.clear()
                                lcd.backlight_enabled = False
                                lcd.close()
                                
                        btn_ja.close(); btn_nein.close()
                        os.system("sudo reboot" if action=="REBOOT" else "sudo shutdown -h now")
                        sys.exit()
                    else: break
                else:
                    if lcd:
                        lcd.clear()
                        lcd.write_string("Starte...")
                        lcd.cursor_pos = (1, 0)
                        lcd.write_string(fix_umlaute(name))
                    btn_ja.close(); btn_nein.close()
                    time.sleep(0.5)
                    os.execv(sys.executable, ['python3', os.path.join(config.BASE_DIR, action)])
            time.sleep(0.1)

if __name__ == "__main__":
    main()