import sqlite3
import evdev
from evdev import InputDevice, categorize, ecodes

# --- KONFIGURATION ---
RFID_PATH = '/dev/input/by-id/usb-16c0_27db-event-kbd'
DB_FILE = "mitglieder.db"

def init_db():
    conn = sqlite3.connect(DB_FILE)
    c = conn.cursor()
    # Tabelle für Mitglieder: ID, Name, Vorname, Gartennummer
    c.execute('''CREATE TABLE IF NOT EXISTS users 
                 (card_id TEXT PRIMARY KEY, name TEXT, vorname TEXT, gartennummer TEXT)''')
    conn.commit()
    conn.close()

def register_user(card_id):
    print(f"\n--- NEUE KARTE ERKANNT: {card_id} ---")
    vorname = input("Vorname: ")
    name = input("Nachname: ")
    garten = input("Gartennummer: ")
    
    try:
        conn = sqlite3.connect(DB_FILE)
        c = conn.cursor()
        c.execute("INSERT OR REPLACE INTO users (card_id, name, vorname, gartennummer) VALUES (?, ?, ?, ?)", 
                  (card_id, name, vorname, garten))
        conn.commit()
        conn.close()
        print(f"Erfolg: {vorname} {name} (Garten {garten}) wurde gespeichert!\n")
    except Exception as e:
        print(f"Fehler beim Speichern: {e}")

# --- HAUPTAPPLIKATION ---
init_db()
try:
    device = InputDevice(RFID_PATH)
    print("REGISTRIERUNGS-MODUS AKTIV")
    print("Bitte eine NEUE Karte scannen, um Daten einzugeben...")
    
    id_buffer = ""
    for event in device.read_loop():
        if event.type == ecodes.EV_KEY:
            data = categorize(event)
            if data.keystate == 1:
                if data.keycode == 'KEY_ENTER':
                    if id_buffer:
                        register_user(id_buffer)
                        print("Warte auf nächste Karte...")
                    id_buffer = ""
                else:
                    val = data.keycode.replace('KEY_', '')
                    if len(val) == 1 and val.isdigit():
                        id_buffer += val
except KeyboardInterrupt:
    print("\nRegistrierung beendet.")
except Exception as e:
    print(f"Fehler: {e}")
